/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;

@Singleton
public class GameMaterialDictionary {
    private ObjectMapper objectMapper = new ObjectMapper();
    private Map<Long, GameMaterial> idMap = new ConcurrentHashMap<Long, GameMaterial>();
    private Map<String, GameMaterial> nameMap = new ConcurrentHashMap<String, GameMaterial>();
    private Map<GameMaterialType, List<GameMaterial>> typeMap = new ConcurrentHashMap<GameMaterialType, List<GameMaterial>>();

    @Inject
    public GameMaterialDictionary() throws IOException {
        this(new File("assets/definitions/materials.json"));
    }

    public GameMaterialDictionary(File definitionsJsonFile) throws IOException {
        List gameMaterials = (List)this.objectMapper.readValue(FileUtils.readFileToString(definitionsJsonFile, "UTF-8"), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, GameMaterial.class));
        for (GameMaterialType gameMaterialType : GameMaterialType.values()) {
            this.typeMap.put(gameMaterialType, new LinkedList());
        }
        for (GameMaterial gameMaterial : gameMaterials) {
            this.idMap.put(gameMaterial.getMaterialId(), gameMaterial);
            this.nameMap.put(gameMaterial.getMaterialName(), gameMaterial);
            this.typeMap.get((Object)gameMaterial.getMaterialType()).add(gameMaterial);
        }
    }

    public GameMaterial getByName(String materialName) {
        return this.nameMap.get(materialName);
    }

    public GameMaterial getById(long materialId) {
        return this.idMap.get(materialId);
    }

    public Iterable<GameMaterial> getAll() {
        return this.idMap.values();
    }

    public List<GameMaterial> getByType(GameMaterialType type) {
        return this.typeMap.get((Object)type);
    }
}

